#include <stdlib.h>
#include <stdio.h>
#include <GL/glut.h>

int board[3][3];   //  3x3-as tmb	
//
//  sznek trlse
// 
void init(void)
	{
   int i, j;
	for (i = 0; i < 3; i++)
		{
      for (j = 0; j < 3; j ++)
			{
         board[i][j] = 0;
			}
		}
   glClearColor (0.0, 0.0, 0.0, 0.0);
	}
//
// 9 ngyzet kirajzolsa, minden ngyzet 2 nvvel rendelkezik, 
//	sor s oszlopnevekkel
// 
void drawSquares(GLenum mode)
	{
	GLuint i, j;
	for (i = 0; i < 3; i++) 
		{
		if (mode == GL_SELECT) glLoadName (i);
		for (j = 0; j < 3; j ++) 
			{
			if (mode == GL_SELECT) glPushName (j);
			glColor3f ((GLfloat) i/3.0, (GLfloat) j/3.0, (GLfloat) board[i][j]/3.0);
			glRecti (i, j, i+1, j+1);
			if (mode == GL_SELECT) glPopName ();
			}
		}
	}
//
// a tallatok feldolgozsa
//
void processHits (GLint hits, GLuint buffer[])
	{
   unsigned int i, j;
   GLuint ii, jj, names, *ptr;

   printf ("talalatok szama = %d\n", hits);
   ptr = (GLuint *) buffer;
   for (i = 0; i < hits; i++) 
		{	
      names = *ptr;
      printf (" nevek szama a talalaton belul = %d\n", names); ptr++;
      printf(" z1 = %g;", (float) *ptr/0x7fffffff); ptr++;
      printf(" z2 = %g\n", (float) *ptr/0x7fffffff); ptr++;
      printf ("   a nevek: ");
      for (j = 0; j < names; j++) 
			{
         printf ("%d ", *ptr);
         if (j == 0)  /*  sor es oszlop beallitasa  */
            ii = *ptr;
         else if (j == 1)
            jj = *ptr;
         ptr++;
			}
      printf ("\n\n\n");
      board[ii][jj] = (board[ii][jj] + 1) % 3;
		}
}

#define BUFSIZE 512

void pickSquares(int button, int state, int x, int y)
	{
   GLuint selectBuf[BUFSIZE];
   GLint hits;
   GLint viewport[4];
	//
	// csak akkor hivodik meg ha a bal egrgomb le van nyomva
	//
   if (button != GLUT_LEFT_BUTTON || state != GLUT_DOWN)
		{
      return;
		}

   glGetIntegerv (GL_VIEWPORT, viewport);

   glSelectBuffer (BUFSIZE, selectBuf);
   (void) glRenderMode (GL_SELECT);

   glInitNames();
   glPushName(0);

   glMatrixMode (GL_PROJECTION);
   glPushMatrix ();
		/*  5x5 os terlet a kurzor krl	*/
		gluPickMatrix (x, y, 5.0, 5.0, viewport);
		gluOrtho2D (0.0, 3.0, 0.0, 3.0);
		drawSquares (GL_SELECT);
   glPopMatrix ();
   glFlush ();

   hits = glRenderMode (GL_RENDER);
   processHits (hits, selectBuf);
   glutPostRedisplay();
	} 

void display(void)
	{
   glClear(GL_COLOR_BUFFER_BIT);
   drawSquares (GL_RENDER);
   glFlush();
	}

void reshape(int w, int h)
	{
   glViewport(0, 0, w, h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluOrtho2D (0.0, 3.0, 0.0, 3.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
	}

int main(int argc, char** argv)
	{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (100, 100);
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init ();
   glutReshapeFunc (reshape);
   glutDisplayFunc(display); 
   glutMouseFunc (pickSquares);
   glutMainLoop();
   return 0; 
	}
